﻿;Copyright 2009-2023 John T. Haller of PortableApps.com
;Website: https://portableapps.com/

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

;=== Runtime Switches
Unicode true 
ManifestDPIAware true
AutoCloseWindow true
CRCCheck on
RequestExecutionLevel user
XPStyle on
SetCompress auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize on
ShowInstDetails nevershow
SilentInstall silent

;=== Defines
!define APP_NAME "PeerBlock Plus Portable Updater"
!define PRODUCT_VERSION "1.0.0.0"
!define WEBSITE "PortableApps.com"

;=== Program Details
Name "${APP_NAME}"
OutFile "..\..\App\Updater\PeerBlockPortablePlusUpdater.exe"
Caption "PeerBlock Plus Portable Updater"
VIProductVersion "${PRODUCT_VERSION}"
VIAddVersionKey ProductName "${APP_NAME}"
VIAddVersionKey Comments "Blocklist updater"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${APP_NAME}"
VIAddVersionKey FileVersion "${PRODUCT_VERSION}"
VIAddVersionKey ProductVersion "${PRODUCT_VERSION}"
VIAddVersionKey InternalName "${APP_NAME}"
VIAddVersionKey LegalTrademarks "PortableApps.com is a trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "PeerBlockPortablePlusUpdater.exe"

;=== Constants
!define UPDATER_DATABASE_URL "https://mirror.codebucket.de/transmission/blocklist.p2p.gz" ;blocklist

;=== Include
!include FileFunc.nsh
!insertmacro GetOptions
!include LogicLib.nsh

Icon "..\..\App\AppInfo\appicon.ico"

Var bolDebugMode

Section "Updating" SecUpdating
	InitPluginsDir
	${GetOptions} "$CMDLINE" "/OUTPUT=" $0
	${If} $0 == ""
		StrCpy $0 "$EXEDIR\..\..\Data\CustomLists\CustomCombined\blocklist.p2p.gz"
		StrCpy $bolDebugMode true
	${EndIf}
	inetc::get /caption "Updating Combined Blocklist" /banner "Updating..." /nocancel "${UPDATER_DATABASE_URL}" "$0" /end
	Pop $R0
	${If} $bolDebugMode == true
		MessageBox MB_OK "Debug mode output:$\r$\n$\r$\nDownload: ${UPDATER_DATABASE_URL}$\r$\n$\r$\nOutput: $0$\r$\n$\r$\nHTTP Response: $R0"
	${EndIf}
SectionEnd